/**
 * Funktionalitaet der Ampel 
 * 
 * xPos: x-Position der Ampel innerhalb des Fensters 
 * 
 * 2008 - 05 - 15
 * D. Bergmann
 */
 
public class AMPEL
{
    // Instanzvariablen
    private KREIS    rotesLicht;
    private KREIS    gelbesLicht;
    private KREIS    gruenesLicht;
    private SCHALTER roterSchalter;
    private SCHALTER gelberSchalter;
    private SCHALTER gruenerSchalter;
    private ZAEHLER_ZYKLISCH Zustand;

    /**
     * Konstruktor fuer Objekte der Klasse AMPEL
     */
    public AMPEL(int xPos)
    {
        // Instanzvariable initialisieren
        rotesLicht      = new KREIS(xPos, 60, 60, rot);
        roterSchalter   = new SCHALTER(rotesLicht);
        gelbesLicht     = new KREIS(xPos, 140, 60, gelb);
        gelberSchalter  = new SCHALTER(gelbesLicht);
        gruenesLicht    = new KREIS(xPos, 220, 60, gruen);
        gruenerSchalter = new SCHALTER(gruenesLicht);
        Zustand         = new ZAEHLER_ZYKLISCH(3);
        Reset();
    }
    
    public void Reset()
    {
       Zustand.Set_Null();
       rot();
    }
    
    public void rot()
    {
        roterSchalter.Einschalten();
        gelberSchalter.Ausschalten();
        gruenerSchalter.Ausschalten();
    }
    
    public void rot_gelb()
    {
        roterSchalter.Einschalten();
        gelberSchalter.Einschalten();
        gruenerSchalter.Ausschalten();
    }

    public void gruen()
    {
        roterSchalter.Ausschalten();
        gelberSchalter.Ausschalten();
        gruenerSchalter.Einschalten();
    }
    
    public void gelb()
    {
        roterSchalter.Ausschalten();
        gelberSchalter.Einschalten();
        gruenerSchalter.Ausschalten();
    }
    
    public void alleEinschalten()
    {
        roterSchalter.Einschalten();
        gelberSchalter.Einschalten();
        gruenerSchalter.Einschalten();
    }
    
    public void alleAusschalten()
    {
        roterSchalter.Ausschalten();
        gelberSchalter.Ausschalten();
        gruenerSchalter.Ausschalten();
    }
    
    public void Schalten()
    {
       Zustand.Zaehlen();
       Anzeigen();
    }
    
    private void Anzeigen()
    {
        if (Zustand.Get_Zaehlerstand() == 0) {rot();};
        if (Zustand.Get_Zaehlerstand() == 1) {rot_gelb();};
        if (Zustand.Get_Zaehlerstand() == 2) {gruen();};
        if (Zustand.Get_Zaehlerstand() == 3) {gelb();};
    } 
}
